import pandas as pd   
import pickle


# Load the dataset    
fastfood = pd.read_csv("fastfood.csv")  

# Assuming the dataset is loaded as a DataFrame named 'fastfood'   
keywords = ['sandwich', 'wrap', 'salad', 'burger', 'burrito', 'taco']   
   
# Make the filtering case-insensitive   
fastfood['item_lower'] = fastfood['item'].str.lower()   
   
# Filter the dataset using the keywords   
filtered_fastfood = fastfood[fastfood['item_lower'].str.contains('|'.join(keywords))]   
   
# Drop the 'item_lower' column as it's not needed anymore   
filtered_fastfood = filtered_fastfood.drop(columns=['item_lower'])   

print(filtered_fastfood)
pickle.dump(filtered_fastfood,open("./ref_result/filtered_fastfood.pkl","wb"))
